function [time, dbins, sizedist] = hiscale_importSMPS()

cd('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\SMPS - Scanning Mobility Particle Sizer - S01');

currdir = dir;
time = [];

sizedist = [];
% checkbinsize = [];

for i = 1:length(currdir)
	
	cdfcheck = ~isempty(strfind(currdir(i).name,'.cdf')) || ~isempty(strfind(currdir(i).name,'.nc'));
	if cdfcheck == 0
		continue
	end
	currfile = currdir(i).name;
	datestartidx = 18;
	year_range = datestartidx : datestartidx +3;
	month_range = datestartidx +4 : datestartidx +5;
	day_range = datestartidx +6 : datestartidx +7;
	startdate = [str2num(currfile(year_range)), str2num(currfile(month_range)), str2num(currfile(day_range)), 0, 0, 0];
	sec_time = ncread(currfile,'time');
	
	currtimemat = repmat(startdate,length(sec_time),1);
	currtimemat(:,6) = currtimemat(:,6) + sec_time;
	currtimemat = datetime(currtimemat);
	time = [time ; currtimemat];
	
	dbins = ncread(currfile,'diameter_midpoint');
	dbins = double(dbins);
% 	checkbinsize = [checkbinsize , numel(dbins)];
	
	currsizedist = ncread(currfile,'number_size_distribution');
	currsizedist = double(currsizedist);
	if isempty(sizedist)
		sizedist = currsizedist;
	else
		sizedist = [sizedist,currsizedist];
	end
	
	
end

sizedist(sizedist == -9999) = NaN;

dbins = dbins(67:173);
sizedist = sizedist(67:173,:);





end